function [tri] = Mesh_D(rinc,rnum,ainc)
%Given the increment in radius and increment in angle, this program outputs
%the corresponding nodal coordinates in unit disc and delaunay associated
%to it. In the tip, it follows rinc meshing, but in cylinder rnum overrides
%rinc.  Rnum specifies number of nodes the [.5,1] region will be broken
%into.  [.5,1] in virtual space is the physical tube length.
%   We create a uniform grid of the square [0,1]\times [0,2\pi] 
%in $(r,\theta)$ coordinates. This grid is mapped onto the disc by the 
%standard (r*cos\theta,rsin\theta) map.  Matlab's built in delaunay 
%function is used to generate the triangulation.  

%Number of nodes on each axis.
nr = floor(.5/rinc) + rnum; %For the tip and then cylinder
nt = floor(2*pi/ainc);

raxis = zeros(1,nr);
taxis = zeros(1,nt);

%Setup nodes on each axis. It includes boundary nodes.
for i=1:nr
    if i<= floor(.5/rinc)
        raxis(1,i) = (i)*rinc; %mesh the tip
    else
        raxis(1,i) = (floor(.5/rinc))*rinc + (i - floor(.5/rinc))*(.5/rnum); %mesh the cylinder height.
                                                %Shift by the last radius value in tip, and then proceed 
                                                %by increments .5/rnum the rest of cylinder height 
    end
end

for i=1:nt
    taxis(1,i) = (i)*ainc;
end

%Grid on standard square. \theta is constant on a block while r varies.  So
%it's ordered by cycling across and up. At (j-1)*nr+nr have boundary node
%for j=1:nt
for j=1:nt
    for i=1:nr
    rnodes((j-1)*nr+i,1) = raxis(1,i);
    tnodes((j-1)*nr+i,1) = taxis(1,j);
    end
end

%Here we map the nodes into the x-y plane and blip in the origin.
xnodes = rnodes.*cos(tnodes);
ynodes = rnodes.*sin(tnodes);
xnodes(nr*nt+1,1) = 0;
ynodes(nr*nt+1,1) = 0;

%Delaunay now meshes the nodes in x-y space.
%tri = delaunay(xnodes,ynodes);
tri = DelaunayTri(xnodes,ynodes);
%To plot this, use triplot(tri,x,y)
%Try command nearestNeighbor
%Try command pointLocation